k6 `v0.56.0` is here 🎉! This release includes:

- We've merged xk6-browser into k6.
- Many small improvements, bug fixes and internal refactors.

## Breaking changes

- [browser#1541](https://github.com/grafana/xk6-browser/pull/1541) Removes `accessibility-events` from a test, which is no longer a valid permission that can be granted by the latest version of Chromium/Chrome.
- [#4093](https://github.com/grafana/k6/pull/4093) Unexports `lib/consts.FullVersion` from the k6's Golang API.

## New features

### Merge browser code in k6 codebase [#4056](https://github.com/grafana/k6/pull/4056)

While the browser module has been stabilized, the codebase was not moved inside of k6.

As part of the stabilization this is now also merged in the k6 codebase. In the following months we would move issues from the [xk6-browser](https://github.com/grafana/xk6-browser) repo and then archive it.

## UX improvements and enhancements

- [browser#1536](https://github.com/grafana/xk6-browser/pull/1536) Removes `Headless` from the user agent to prevent test traffic from being blocked.
- [browser#1553](https://github.com/grafana/xk6-browser/pull/1553) Reduces logging noise produced by the browser module.
- [#4093](https://github.com/grafana/k6/pull/4093) Introduces a `--json` flag to a `k6 version` sub-command, which switches an output to a JSON format.
- [#4140](https://github.com/grafana/k6/pull/4140) Tags browser module metrics with a `resource_type` tag which can be one of these values: `"Document"`, `"Stylesheet"`, `"Image"`, `"Media"`, `"Font"`, `"Script"`, `"TextTrack"`, `"XHR"`, `"Fetch"`, `"Prefetch"`, `"EventSource"`, `"WebSocket"`, `"Manifest"`, `"SignedExchange"`, `"Ping"`, `"CSPViolationReport"`, `"Preflight"`, `"Other"`, or `"Unknown"`.
- [#4092](https://github.com/grafana/k6/pull/4092) Populates `__ENV.K6_CLOUDRUN_TEST_RUN_ID` with the corresponding value for local executions streaming results to the Cloud: `k6 cloud run --local-execution`.

## Bug fixes

- [browser#1507](https://github.com/grafana/xk6-browser/pull/1507) Fixes the `Geolocation.Accuracy` field.
- [browser#1515](https://github.com/grafana/xk6-browser/pull/1515) Fixes Sobek `Object.Get(key)` by returning `*[]any` instead of `[]any`.
- [browser#1534](https://github.com/grafana/xk6-browser/pull/1534) Fixes `locator` APIs to wait during a navigation without erroring out.
- [browser#1538](https://github.com/grafana/xk6-browser/pull/1538) Fixes `frame.title`.
- [browser#1542](https://github.com/grafana/xk6-browser/pull/1542) Fixes a panic which can occur when a frame navigates.
- [browser#1547](https://github.com/grafana/xk6-browser/pull/1547) Fixes a panic due to events associated to stale frames.
- [browser#1552](https://github.com/grafana/xk6-browser/pull/1552) Fixes a panic for `locator.selectOption` when value is an object.
- [browser#1559](https://github.com/grafana/xk6-browser/pull/1559) Fixes a panic for `page.screenshot`.
- [browser#1544](https://github.com/grafana/xk6-browser/pull/1544) Fixes a nil pointer dereference when calling `evaluate` or `evaluateHandle` with an invalid page function.
- [#4058](https://github.com/grafana/k6/pull/4058) Fixes the namespaced object export when default is the only one available.
- [#4132](https://github.com/grafana/k6/pull/4132) Returns an error when a page is `null` during the creation of a page.

## Maintenance and internal improvements

- [browser#1504](https://github.com/grafana/xk6-browser/pull/1504), [browser#1510](https://github.com/grafana/xk6-browser/pull/1510), [browser#1511](https://github.com/grafana/xk6-browser/pull/1511) [browser#1512](https://github.com/grafana/xk6-browser/pull/1512) [browser#1513](https://github.com/grafana/xk6-browser/pull/1513), [browser#1518](https://github.com/grafana/xk6-browser/pull/1518), [browser#1519](https://github.com/grafana/xk6-browser/pull/1519), [browser#1520](https://github.com/grafana/xk6-browser/pull/1520), [browser#1523](https://github.com/grafana/xk6-browser/pull/1523), [browser#1521](https://github.com/grafana/xk6-browser/pull/1521), [browser#1524](https://github.com/grafana/xk6-browser/pull/1524), [browser#1526](https://github.com/grafana/xk6-browser/pull/1526), [browser#1527](https://github.com/grafana/xk6-browser/pull/1527), [browser#1531](https://github.com/grafana/xk6-browser/pull/1531)  Removes Sobek out of business logic layers.
- [browser#1528](https://github.com/grafana/xk6-browser/pull/1528), [browser#1529](https://github.com/grafana/xk6-browser/pull/1529), [browser#1557](https://github.com/grafana/xk6-browser/pull/1557) Aligns repo with k6.
- [browser#1517](https://github.com/grafana/xk6-browser/pull/1517) Fixes internal tests.
- [browser#1540](https://github.com/grafana/xk6-browser/pull/1540) Refactors internals.
- [#4049](https://github.com/grafana/k6/pull/4049), [#4095](https://github.com/grafana/k6/pull/4095), [browser#1535](https://github.com/grafana/xk6-browser/pull/1535), [browser#1537](https://github.com/grafana/xk6-browser/pull/1537), [#4073](https://github.com/grafana/k6/pull/4073), [#4101](https://github.com/grafana/k6/pull/4101), [#4103](https://github.com/grafana/k6/pull/4103), [#4104](https://github.com/grafana/k6/pull/4104), [#4134](https://github.com/grafana/k6/pull/4134), [#4148](https://github.com/grafana/k6/pull/4148) Updates dependencies.
- [#4057](https://github.com/grafana/k6/pull/4057) Update k6-taskqueue-lib to drop goja dependency.
- [#4076](https://github.com/grafana/k6/pull/4076) modules.NewModuleInstance doc updates.
- [#4137](https://github.com/grafana/k6/pull/4137), [#4148](https://github.com/grafana/k6/pull/4148) Updates a dependency and adds release notes.
- [#4099](https://github.com/grafana/k6/pull/4099), [#4114](https://github.com/grafana/k6/pull/4114) Fixes to CI after browser merge, around running tests on windows.
- [#4102](https://github.com/grafana/k6/pull/4102) Fix windows-packaging CI after update of the windows github action.
- [#4047](https://github.com/grafana/k6/pull/4047) Uses `(*Regexp).MatchString` to avoid unnecessary `[]byte` conversions. Thanks, @Juneezee for the contribution.
- [#4055](https://github.com/grafana/k6/pull/4055) Updates release template.
- [#4143](https://github.com/grafana/k6/pull/4143) Fix k6packager workflow which also broke v0.55.1 initial release.
- [#4063](https://github.com/grafana/k6/pull/4063) Updates usage report to return whether k6 was ran from CI.
- [#4072](https://github.com/grafana/k6/pull/4072) Uses the precompiled 'gotip' on the xk6 workflow.
- [#4084](https://github.com/grafana/k6/pull/4084) Updates usage report to return usage of the deprecated 'ext.loadimpact' option.

## Roadmap

### Removal of deprecated `k6/experimental/browser` module

Since `v0.52.0` we have had a non experimental version of the browser module (`k6/browser`). We urge you to [migrate](https://grafana.com/docs/k6/latest/using-k6-browser/migrating-to-k6-v0-52/) your scripts over to the non experimental browser module as we will be removing the experimental version of it in the next release (`v0.57.0`).

